/* Prepare iButton for PGP use */
/* Master erase, download applet, set PIN */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "jibapi.h"

#define APPLET			"PGPkey"
#define PIN				"PASSWORD"

#define PGPKEY_CLA				(BYTE)0xB5
#define PGPKEY_INS_INIT			(BYTE)0
#define PGPKEY_INS_SETPIN		(BYTE)1
#define PGPKEY_INS_SETMODULUS	(BYTE)2
#define PGPKEY_INS_GETMODULUS	(BYTE)3
#define PGPKEY_INS_SETEXPONENT	(BYTE)4
#define PGPKEY_INS_SETKEYID		(BYTE)5
#define PGPKEY_INS_GETKEYID		(BYTE)6
#define PGPKEY_INS_EXPONENTIATE	(BYTE)7
#define PGPKEY_INS_SETBLOB		(BYTE)8
#define PGPKEY_INS_APPENDBLOB	(BYTE)9
#define PGPKEY_INS_GETBLOB		(BYTE)10
#define PGPKEY_INS_RSAKEYGEN	(BYTE)11

#define LOAD_UNLOAD_TIME  500

/* Error codes */
#define ERR_OK			 0
#define ERR_BADVERSION	-1
#define ERR_NOJIBS		-2
#define ERR_MULTIJIBS	-3
#define ERR_FILEOPEN	-4
#define	ERR_FAIL		-20

char *devs[] = { "COM1", "COM2", "COM3", "COM4"};
BYTE devcount = 4;

char filebuf[4096];
int filelen;

struct {
	char *str;
	int ver;
} verList[] =
{
	{ "0.03.0003", 32 },
	{ "1.00.0004", 33 },
	{ "1.01.0004", 34 },
	{ "1.02.0005", 35 },
	{ "1.03.0005", 36 },
	{ "1.10.0006", 40 },
	{ "1.11.0006", 41 },
	{ "2.00.0006", 51 },
	{ "2.2.0007", 52 },
};
int verListSize = sizeof(verList) / sizeof(verList[0]);

int stringToVersion( char *str, int len )
{
	int i, j;

	for( i=0; i<len; ++i )
	{
		if( str[i]>='0' && str[i]<='9' )
			break;
	}
	if( i == len )
		return -1;

	for( j=0; j<verListSize; ++j )
	{
		if( strlen(verList[j].str) == (unsigned)(len-i) &&
			memcmp(verList[j].str, str+i, len-i) == 0 )
			break;
	}
	if( j == verListSize )
		return -1;

	return verList[j].ver;
}


int doinit( char *devname )
{
  LPRESPONSEAPDU	apdu = NULL;
  AID				aid;
  BYTE				ibCount;
  BYTE				*ibs;
  int				jibVersion;
  BYTE				pinbuf[50];
  char				filename[50];
  FILE				*f;
  
	if( devname != NULL )
	{
		devs[0] = devname;
		devcount = 1;
	}

    SetJiBSearchParams(devcount, devs); 

	/* Search adapters for attached JiBs */
	ibs = FindJiBs(&ibCount);

	if(ibCount == 0)
	{
		return ERR_NOJIBS;
	}

	if( ibCount > 1)
	{
		return ERR_MULTIJIBS;
	}
	SelectJiB(ibs);

	apdu = GetFirmwareVersionString();
	jibVersion = stringToVersion( apdu->Data+1, apdu->Len-1 );
	if( jibVersion < 0 )
	{
		return ERR_BADVERSION;
	}

	sprintf (filename, "%s.jib%02d", APPLET, jibVersion);
	if( (f = fopen( filename, "rb" )) == NULL )
	{
		perror("fopen");
		return ERR_FILEOPEN;
	}

	filelen = fread( filebuf, 1, sizeof(filebuf), f );
	fclose(f);

	aid.Len = strlen( APPLET );
	strcpy( aid.Data, APPLET );
	pinbuf[0] = 0;
	strcpy( pinbuf+1, PIN );

	apdu = MasterErase( );
	if( apdu->SW == ERR_ISO_NORMAL_00 )
		apdu = LoadApplet( filebuf, filelen, &aid );
	if( apdu->SW == ERR_ISO_NORMAL_00 )
		apdu = SetAppletGCMode(1);
	if( apdu->SW == ERR_ISO_NORMAL_00 )
		apdu = Process(PGPKEY_CLA, PGPKEY_INS_SETPIN,
			0, 0, (BYTE)(1+strlen(PIN)), pinbuf, LOAD_UNLOAD_TIME);
	if( apdu->SW == ERR_ISO_NORMAL_00 )
	{
		/* Verify PIN set */
		pinbuf[0] = strlen(PIN);
		strcpy( pinbuf+1+strlen(PIN), PIN );
		apdu = Process(PGPKEY_CLA, PGPKEY_INS_SETPIN,
			0, 0, (BYTE)(1+2*strlen(PIN)), pinbuf, LOAD_UNLOAD_TIME);
	}

	return (apdu->SW == ERR_ISO_NORMAL_00) ? ERR_OK : ERR_FAIL;
}

int main(int argc, char **argv)
{
	int err;

	if(argc > 1)
	{
		err = doinit( argv[1] );
	} else {
		err = doinit( NULL );
	}

	if( err < 0 )
	{
		printf( "Failed, error code %d\n", err );
		exit (1);
	}
	exit (0);
}
